using System;

public class SSEClientAlreadyExistsException : Exception
{
    public SSEClientAlreadyExistsException(string url)
        : base($"An SSE client with URL '{url}' already exists.")
    {
    }
}
public class SSEClientTypeMismatchException : Exception
{
    public SSEClientTypeMismatchException(string url, Type expectedType, Type actualType)
        : base($"Client for URL '{url}' has type '{actualType.Name}' but expected '{expectedType.Name}'.")
    {
    }
}